/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.DataDescription;
import emulator.assembler.DataDescriptionTable;
import emulator.assembler.Instruction;
import emulator.assembler.InstructionList;
import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.CommandDefinition;
import emulator.hardware.nmos6502.CommandSet;
import emulator.util.MemoryPtr;
import java.io.InputStream;

public class Assembler {
    private SymbolTable symbols = new SymbolTable();
    private CommandSet commands = new CommandSet();

    public InstructionList disassemble(byte[] memory, int start, int end) {
        InstructionList instructions = new InstructionList(this.symbols);
        int address = start;
        while (address <= end) {
            address = this.disassembleOneInstruction(memory, instructions, address);
        }
        return instructions;
    }

    public InstructionList disassembleLines(byte[] memory, int start, int line_cnt) {
        InstructionList instructions = new InstructionList(this.symbols);
        int address = start;
        int i = 0;
        while (i < line_cnt && address < 65536) {
            address = this.disassembleOneInstruction(memory, instructions, address);
            ++i;
        }
        return instructions;
    }

    public InstructionList disassembleLines(DataDescriptionTable table, byte[] memory, int start, int line_cnt) {
        InstructionList instructions = new InstructionList(this.symbols);
        int address = start;
        int i = 0;
        while (i < line_cnt && address < 65536) {
            DataDescription description = table.getDescriptionForAddress(address);
            address = this.dissambleData(memory, instructions, description);
            ++i;
        }
        return instructions;
    }

    private int dissambleData(byte[] memory, InstructionList instructions, DataDescription description) {
        int address = description.getAddress();
        if (description.isCode()) {
            address = this.disassembleOneInstruction(memory, instructions, address);
        } else {
            instructions.addInstruction(address, this.getData(memory, address, description.getLength()));
            address += description.getLength();
        }
        return address;
    }

    public Instruction dissambleData(byte[] memory, DataDescription description) {
        if (description.isCode()) {
            return this.getInstruction(memory, description.getAddress());
        }
        return this.getData(memory, description.getAddress(), description.getLength());
    }

    private int disassembleOneInstruction(byte[] memory, InstructionList instructions, int address) {
        Instruction instruction = this.getInstruction(memory, address);
        instructions.addInstruction(address, instruction);
        return address += instruction.getByteCount();
    }

    public void loadSymbols(InputStream input_stream, String sourceName) {
        this.symbols.load(input_stream, sourceName);
    }

    public Instruction getInstruction(byte[] memory, int address) {
        CommandDefinition def = this.commands.getCommand(new HwByte((long)memory[address]));
        return new Instruction(new MemoryPtr(memory, address), def.getCommand(), def.getOperand(), this.symbols);
    }

    private Instruction getData(byte[] memory, int address, int length) {
        return new Instruction(new MemoryPtr(memory, address), length);
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }
}

